//
// Fragment shader for Kaleidoscope effect
//
// Author: Shirley Carter
//

uniform sampler2DRect texUnit;
uniform  vec4 modulateColor;

uniform vec4 textureRect;

uniform float time; 
uniform vec2 drawingOffset;
uniform vec2 drawingScale;
uniform vec4 drawingBoundsRect;

varying vec2 gUV;
bool InBound(float x, float a, float b)
{
    return (x > a && x<=b);
}
void main(void)
{
    if ( gUV.x< textureRect.x || gUV.x> textureRect.x+textureRect.z || gUV.y < textureRect.y || gUV.y > textureRect.y+textureRect.w )
        gl_FragColor = vec4(0.0,0.0,0.0,0.0);
    else {
        float textureWidth = textureRect.z;
        float textureHeight = textureRect.w; 

        // This pixel location
        vec3 pCoord = gl_FragCoord.xyz;
        // Transform back to render traget coord space
        pCoord /= vec3(drawingScale, 1);
        pCoord += vec3(drawingOffset, 0);
        
        vec2 drawingBoundsOrigin = drawingBoundsRect.xy;
        float drawingBoundsWidth = drawingBoundsRect.z;
        float drawingBoundsHeight = drawingBoundsRect.w;
        
        vec2 p;
        p.x = -1.0 + 2.0/drawingBoundsWidth*(pCoord.x-drawingBoundsOrigin.x);
        p.y = -1.0 + 2.0/drawingBoundsHeight*(pCoord.y-drawingBoundsOrigin.y);
        
        float r = length(p);
        float a = atan(p.y, p.x);
        float sides = 7.0;
        float tau = 2.0 * 3.1416;

        a = mod(a, tau/sides);
        a = abs(a - tau/sides/2.0);
        
        vec2 uv;
        
        uv.x = sides*a/3.1416;
        uv.y = sin(sides*r+time) + sides/10.0*cos(time+7.0*a);
       
        uv.x = 0.5*(uv.x+1.0)*textureWidth +textureRect.x;
        uv.y = 0.5*(uv.y+1.0)*textureHeight+textureRect.y;

        uv.x = InBound(uv.x, textureRect.x, textureRect.x+textureWidth)?uv.x:gUV.x;
        uv.y = InBound(uv.y, textureRect.y, textureRect.y+textureHeight)?uv.y:gUV.y;

        vec3 col =  texture2DRect(texUnit,uv).xyz;
        float w = .5+.5*(sin(time+sides*r)+ sides/10.0*cos(time+sides*a));

        gl_FragColor.rgb = modulateColor.rgb*col*w;
        gl_FragColor.a = texture2DRect(texUnit, gUV).a; 

    /*
            if ( uv.x < 900.0)
                 gl_FragColor= vec4(0,0,1,1);
            else 
                gl_FragColor= vec4(1,0,0,1); 
  */
    }
}

